// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef EXI_AD16_H
#define EXI_AD16_H

#include "hw_ei.h"

class EXIDevice_AD16 : public EXIDevice {
public:
	EXIDevice_AD16();
	EXIResultValue writeImm(DWORD size, DWORD data);
	EXIResultValue writeDMA(DWORD size, DWORD address, MemInterface &mem);
	EXIResultValue readImm(DWORD size, DWORD &data);
	EXIResultValue readDMA(DWORD size, DWORD address, MemInterface &mem);
	void notify_deselected();
private:
	enum State { AD16_READY, AD16_MAGIC, AD16_ID, AD16_WRITE, AD16_READ } state;
	DWORD reg;
};

#endif	//EXI_AD16_H
